# Review A Review of Global Challenges and Survival Strategies of Small and Medium Enterprises (SMEs)

Sisira Kumara Naradda Gamage $\mathbf { 1 } _ { \mathbb { O } }$ , EMS Ekanayake 2, GAKNJ Abeyrathne , RPIR Prasanna 1,\*, JMSB Jayasundara 3 and PSK Rajapakshe 3

1 Department of Economics, Rajarata University of Sri Lanka, Mihintale 50300, Sri Lanka; naraddagamage@ssh.rjt.ac.lk (S.K.N.G.); abeyrathne.rjt@ssh.rjt.ac.lk (G.A.)   
2 Department of Social Sciences, Rajarata University of Sri Lanka, Mihintale 50300, Sri Lanka; emsekanayake@ssh.rjt.ac.lk   
3 Department of Environmental Management, Rajarata University of Sri Lanka, Mihintale 50300, Sri Lanka; jmsb1610@ssh.rjt.ac.lk (J.J.); pskr75@ssh.rjt.ac.lk (P.R.) ￥ Correspondence: prasannarjt@ssh.rjt.ac.lk; Tel.: +94-71-072-3083

Received: 7 September 2020; Accepted: 25 September 2020; Published: 2 October 2020

Abstract: Economic globalization has created many challenges for small and medium enterprises (SMEs) due to the rapid increase in competition. Therefore, the downfall rate of SMEs is relatively high, a short period after their commencement. Accordingly, SMEs need to adopt survival strategies and strategic methods to succeed in confronting the various global challenges faced by the SME sector. This study critically examined the existing literature on global challenges for SMEs to understand the SMEs’ survival and successive mechanisms in the present competitive business background. Published information related to the field by the multilateral institutions and 110 research papers published by four recognized publishing companies, i.e., Emerald, Elsevier, Taylor and Francis, and MDPI, were chosen for this study. The review revealed the critical global challenges for SMEs within the context of economic globalization. They are the global market competition, global finance and economic crises, information communication technology, the emergence of multi-national corporations, transnational corporations, consumer changes and especially their preferences, trade dumping, international terrorism, and religious conflicts and trade wars. Furthermore, the study considered the survival strategies of SMEs in the industrial platform to recognize sustainability-related policies, specifically, the necessity for a robust theoretical examination on the survival strategies of SMEs in the field of global challenges.

Keywords: economic crisis; global challenges; international terrorism; multi-national corporations; small and medium enterprises; survival strategies; trade war

# 1. Introduction

Small and medium enterprises (SMEs) play a significant role in the economic development sector worldwide. Since the 1990s, researchers have been interested in investigating the role of SMEs on the development platform because of the economic globalization (Slater and Narver 1990; Alfred and Wilson 1996), and during the period of economic globalization, changes in the global economy have generated both challenges and opportunities for SMEs (Dominguez and Mayrhofer 2017). Globalization is always discussed as a mode associated with the production systems, cultures, and political processes in the modernized world (Aspers and Kohl 2015). Additionally, globalization has encompassed the liberalization of trade, ushered in by the WTO trade regime since 1995 (Martin 2001). The globalization concept emphasizes how economic cultures and political systems are transmitted in terms of dependency modes. According to Todaro and Smith (2015), globalization provides new feasibilities for eradicating global poverty. It could also be advantageous for developing countries, directly and indirectly, via cultural, social, scientific, and technological sharing, including trade and finance. Thus, the world economic globalization could be identified as an opportunity for both developed and developing countries to improve their economic prosperity by dealing with global trade (Ahmedova 2015; WTO 2016; Prasanna et al. 2019). It has two key domains, namely, the globalization of production, which is addressed as a source of goods from countries in the world to obtain benefits from social differentiation in the cost of production, and the globalization of the market places that reduces the cross-border trade constraints (Erixon 2018).

Economic globalization concentrates on cross border activities such as international investment, international trade, and strategic contracts for product development, production, sourcing, and marketing, which form the global business atmosphere for all ventures (Chew and Yeung 2001; Sener et al. 2014). Today, the speed of globalization has intensified by the growth of information and communication technology, and most SMEs are following that strategy to improve their business competitiveness in the market (Sung et al. 2016). Further, the collapse of socialist economies, the interaction of the market economy, financial liberty, and deregulation of capital movements have intensified the globalization procedure (Sung et al. 2016). Thus, the ventures cannot move away from globalization and skip their challenges (Maarof and Mahmud 2016). Globalization is also recognized as a motivational fact for businesses’ competitiveness (Sceulovs and Gaile-Sarkane 2014). During the last few decades, the liberalization of trade and globalization enhanced customer aspirations and competition between companies (Karaev Schmidt and Sofka 2009). Sener et al. (2014) explained that the globalized business atmosphere encourages the firms to increase their competition as opposed to the competitors even within the same industry.

The world economic globalization is an outstanding source of both opportunities and threats for commercial activities (Mundim et al. 2000). The admittance of financial agreements raises a new challenge for SMEs to maintain the competition in the broad markets apart from the globalization’s actual results (Maarof and Mahmud 2016). Specifically, the survival ability of SMEs in the competition and the ability to globalize business activities have been primarily questioned. The threat of large-scale firms—MNCs (Multi-National Corporations) and TNCs (Trans-National Corporations)—has been noted in the literature since SMEs lack in resources, less innovative capabilities, inconveniences to reach the global at the start, and fewer abilities in the international strategies of SMEs compared to large-scale firms (Ren et al. 2015). However, it provides chances for SMEs to interact with large-scale firms and thereby improve the SMEs’ competitiveness in the market because the interaction gives opportunities SMEs to learn competitive strategies adopted by the large firm (Singh et al. 2008). Thus, the influence of economic competition in the globalization era on SMEs has received much more concentration than other types of ventures because SMEs provide a significant contribution to the economies in developed and developing nations (Sener et al. 2014; Asare et al. 2015; Bilal and Mqbali 2015; Auzzir et al. 2018; Gamage et al. 2019). As cited in the literature, the main issue of SMEs, particularly in developing countries, is that a considerable percentage of SMEs are closed down within a very shorter period of their business commencement (Prasanna et al. 2019). This is mainly due to the emerged competitive challenges in the free market environment of the globalized economy. In this connection, the recent literature revealed three competitive challenges that confront the business entities in the global economy, i.e., sustainability challenges, global challenges, and technological challenges (Noe et al. 2017). The global challenge refers to the ability of firms to protect their domestic markets and enter new emergent markets in the world such as China, India, Brazil, and Russia (Noe et al. 2017). Thus, the central aim of this study is to explore the key global challenges facing SMEs, mainly in the era of economic globalization, by undertaking a systemic review of literature in the fields of SMEs and economic globalization. In this connection, the study reviews each global challenge to reveal its impacts on SME performance, identify the strategies adopted by the SMEs in different settings, and suggest key concerns the SMEs should consider in facing the global challenges.

The rest of the paper is organized as follows: Section 2 defines the keyword of the review—global challenge, Section 3 discusses the key features and importance of SMEs in economic development, and Section 4 explains the research methods of the systemic review with methodological limitations. Section 5 consists of the review literature on global challenges—nature, impacts on SMEs, survival strategies or key concerns the SMEs should consider in facing the global challenge, and Section 6 presents the conclusion and recommendations, and the future research domains.

# 2. The Importance of SMEs in Economic Development

SMEs play a vital role in the industrial modes of developed and developing countries in the present global economy. They are concerned as the most dynamic ventures in the global economy and play a vital role in developing the human well-being of any country. According to recent evidence, SMEs account for 90 percent of ventures and employing about 60 percent labor force in the world (Munro 2013). Hence, SMEs’ contribution to poverty alleviation and sustainable economic growth is decisive (Ayyagari et al. 2007; Zeng et al. 2010; Asare et al. 2015; St-Pierre et al. 2015). Fiseha and Oyelana (2015) emphasized that SMEs cooperate with the development of communities in rural economies in countries worldwide. The role of SMEs in expanding local development is more vital to eradicating poverty, inequality, and unemployment in rural sectors as SMEs support people to fulfill their basic needs and help for marginalized groups, including the disabled, female household heads, uneducated people, and rural families (Fiseha and Oyelana 2015). SMEs encourage inclusive and sustainable economic growth and reduce inequalities, by engaging in favor of the United Nations Sustainable Development Goals (Fonseca and Carvalho 2019) Therefore, in the national policy formulation, all nations accept the SMEs’ capability in addressing the key development challenges, particularly in rural settings (Fiseha and Oyelana 2015). Stuart (2011) emphasized that promoting SMEs help poverty eradication, employment generation, and improving living standards, particularly for women and vulnerable groups via increasing wage income and self-employment. As Miller et al. (2003) state, establishing an own venture has become more attractive than investing several productive years in regular type occupations, which tends to stop the job at any point (Miller et al. 2003). The most significant fact is that SMEs benefit the economy of its capacity for utilizing local resources such as the local raw materials, generation of local savings, supply chances for self-employment, and chances for training semi-skilled laborers via apprenticeship (Asare et al. 2015). It is the most productive sector in creating jobs in any economy (Jeppesen 2005; Singh et al. 2009; Zeng et al. 2010; Ong et al. 2010a; Doh and Kim 2014; Eniola and Entebang 2015; Fiseha and Oyelana 2015; Asare et al. 2015; Auzzir et al. 2018).

Further, SMEs construct a local technological base, encourage the participation of vulnerable groups, provide training grounds for entrepreneurial and managing abilities, and make changes for the usage of own capital resources (Fiseha and Oyelana 2015). In the production sector, SMEs play a vital role as specialist suppliers of components, parts, and assemblies for large-scale firms because SMEs manufacture such necessities at a lower price that is cheaper than the cost of the same product when produced by larger firms (Singh et al. 2008). Thus, subcontracting manufacturing is a great venture practice of SMEs (Wang et al. 2018). SMEs also give chances to TNCs to approach the localized knowledge in terms of local technologies and know-how via the reverse transmit of technological wisdom (Chew and Yeung 2001).

# 3. Theoretical Approaches—Explaining the Impact of Global Challenge and Survival Strategies

Economic literature has no unique theory to explain the impact of global challenges on business firms and strategic approaches adopted by the firms, mainly because of the diversity and changing nature of global challenges.

Based on the great economic depression experienced in the 1930s, Keynes proposed a new theory—Keynesian business cycle theory—to explain the economic crisis (Keynes 1933). The world economy experiences the economic and financial crisis cyclically, and it is one of the global challenges for every business entity, particularly to SMEs in the globalized economy. The Keynesian theory explains the situation using the two concepts—marginal efficiency of capital and effective demand. Specifically, the theory states low effective demand in the economy as a cause of the economic downturn, which results in high unemployment and low production due to the stock accumulation in the economy. It also links with a liquidity trap or shortage of financial liquidity among the investors in the economy. As SMEs are more vulnerable to external shocks, the global economic crisis challenges the production sustainability of the SMEs or standstill the production for a certain period. Thus, the theory suggests the intervention of government in the economy to enhance the aggregate demand, specifically using fiscal and monetary policy instruments. Thus, the Keynesian theory of business cycle proposes an aggregate level explanation about the economic crisis—which is one of the global challenges of business entities—and policy intervention. In the recent economic downturn due to the COVID-19, most countries used the Keynesian view in economic crisis management.

The theory of comparative advantage could be used as a tool to adjust the production system to competition as it helps to allocate the resources to efficient sectors of the economy. Comparative advantage is achieved when a country produces goods or services for a lower opportunity cost than the other countries. This allows a company to sell products and services at a lower price than its competitors, helping them increase sales margins. In terms of SMEs, movements of low-cost product items considering other specific attributes of the products such as price and quality are important in the WTO trade regime to gain competitive advantages from business internationalization.

SWOT (Strengths, Weaknesses, Opportunities and Threats) analysis tool stands for strengths, weaknesses, opportunities, and threats that help an organization identify its internal environmental factors (strengths and weaknesses) and external environmental factors (opportunities and threats). In today’s business world, many organizations do a SWOT analysis for the organization as a part of their strategic planning process before implementing their corporate strategies (Bernroider 2002; Houben et al. 1999; Roth and Washburn 1999). The internal analysis deals with the factors related to satisfying the consumer needs, which are determined by culture, structure, resources, and functional areas (Hai 2011). External analysis will help the organizations to identify opportunities and threats in the environment for the business. The available literature suggests that SMEs have a minimal idea of both the internal and environmental factors they are operating in and a limited understanding of the SWOT analysis (Wiid et al. 2015). Nevertheless, large firms, as well as SMEs, can do a SWOT analysis for the business before implementing corporate strategies because the ultimate goal of SWOT analysis and strategic planning is to gain a sustainable competitive advantage.

Porter’s generic strategies help to determine the strategic position of an organization to gain a competitive advantage (Porter 1985). Michael Porter states four generic strategies based on the market where they compete (broad or narrow) and the source of competitive advantage (cost and differentiation), namely, cost leadership, differentiation, cost focus, and differentiation focus. This is the firm’s choice of competitive scope, and the scope distinguishes between firms targeting a broad industry segment or the narrow industry segment. Not only the large firms, but small and medium enterprises (SMEs) must also analyze its strategic position of the firm. Therefore, it is essential to identify the strategies these firms are adopting. According to Mumbua (2013), cost leadership and differentiation are the best generic strategies for SMEs than cost focus and differentiation focus. Dess and Davis (1984) found that cost leadership has a higher return on assets than a differentiation strategy. In contrast, Pelham (2000) argued that differentiation strategy has a more significant impact on profits than cost leadership strategy. However, Julita and Tanjung (2019) suggested that the most effective strategy for SMEs is cost leadership since the expected objectives of SMEs are increasing profits by reducing costs and setting prices according to the industry average, and these firms can raise market share by applying more low prices and still earn a sufficient profit from each sale of a product or a service due to already pressed costs.

PESTEL, which stands for political, economic, social, technological, environmental, and legal factors, is a strategic planning or marketing research tool that helps organizations to identify the macro-environmental factors that impact the businesses and make better decisions. According to

Yuksel (2012), PESTEL has two primary functions: allowing to identify the environment in which it operates and provides data and information that enable the company to predict situations and circumstances in the future. Therefore, all organizations must identify PESTEL factors to make better decisions. Rakesh (2014) stated that SMEs must scan the external environment to investigate the political, economic, social, technological, environmental, and legal influences on the business before creating business plans or making decisions. At the same time, SMEs need to do PESTEL analysis to be aware of the competitors as these organizations have a high potential for providing employment, promote entrepreneurship, earn foreign exchange to the country, and the dispersal of industries.

A resource-based view is an approach of strategy formulation aimed to attain a competitive advantage based on the organization’s resources (Ong et al. 2010b). According to Barney (1991), a resource-based view allows organizations to look for competitive advantage within themselves rather than outside. On the other hand, the resource-base of particular firm forecasts that the firm’s specific resources can generate competitive advantage and superior performance (Ainuddin et al. 2007). SMEs face more difficulties when entering foreign markets as they have more problems than large firms to access export resources and capabilities (Xie and Suh 2014). The resource-based view suggests that inter-organizational relationships can lead SMEs to get access and availability to resources (either tangible or intangible), which will create a positive impact on the organization’s performance (Rice et al. 2012; Hessels and Parker 2013). Therefore, it is evident that SMEs will be beneficial only when they acquire the right network to get the necessary resources for their performance (Zaheer and Zaheer 2001). Stakeholder theory by Freeman (1984), focuses on the importance of a firm’s relationship with critical stakeholders. Research supports the view that partners/suppliers, employees and customers satisfaction for sustainable organizational success (Fonseca et al. 2016).

In summary, the ideology of the discussed theories relates to the business world in a free trade environment. Thus, in a broad view, theories indicate the importance of improving or establishing firm stability conditions through enhanced competitiveness.

# 4. Methodology

This study aims to review the existing knowledge on how the global challenge, which was intensified in the era of economic globalization, affects the sustainability of SMEs in the modern-day economic competition to broaden the understanding or extend the existing knowledge about the nature of the different kind of global challenges, their impact on SME sector, and strategies adopted by the SME to confront various global challenges. Specifically, broadening the understanding of one of the key challenges of SMEs’ sustainability is essential as the sector plays a decisive role in economic development in developing nations. As mentioned in the background, this study recognized the global challenges as any key trend, pressure, or development in the global economy that has possible influences on changing the SMEs’ business atmosphere.

Hence, papers for this systemic review were first selected based upon the comprehensive web search conducted using three primary phrases related to global challenge: SMEs and Economic Globalization, SMEs and competition, and SMEs and survival strategies. This web search emphasized millions of hits. Hence, secondly, the review interpreted the inclusion and exclusion determinants for the selected papers. Three indicators were chosen for the inclusion determinant—the publishing company, journal impact factor and the Google citations number. The review selected the journal papers published by four publishing companies—Emerald, Elsevier, Tayler and Francis, and MDPI, and strained 256 journal papers for the inclusion determinant.

In the third stage, 110 out of the 256 journal papers were chosen for this investigation by considering the level of relevance of such studies with the central theme of this review. The review avoided the documents that do not match with the research subject at each stage. The main methodological limitation of this review is that selecting papers for this review is purely based on web search (online publications) using three key terminologies and limited to publications of four publishing companies.

The study noted this limitation, indicating existing opportunities to broaden the understanding of the review subject further. The methodology adopted by the review is presented in Figure 1.

![](images/769921544ccad30f81c38dde8cbafe2ada439573d1ee3b35e1106b5de4605b74.jpg)  
Figure 1. The methodology adopted by the review.

# 5. Global Challenges of SME5. Global Challenges of SMEs

Scholars have studied various types of challenges faced by SMEs in developed and developing Scholars have studied various types of challenges faced by SMEs in developed and developing economies in the economic globalization era. Among them, the literature has highlighted the question economies in the economic globalization era. Among them, the literature has highlighted the question of capital instability, innovativeness, regulatory licenses and taxes, workers’ rights, and of capital instability, innovativeness, regulatory licenses and taxes, workers’ rights, and competitiveness competitiveness (Alauddin and Chowdhury 2015; Hoque 2018; Hoque et al. 2018; Zhang and Zhang (Alauddin and Chowdhury 2015; Hoque 2018; Hoque et al. 2018; Zhang and Zhang 2012; Chowdhury et al. 2013; Ibrahim and Masud 2016; Khan et al. 2012; Hoque et al. 2017; Hoque and Awang 2016; Andalib and Darun 2018; Qureshi et al. 2011; Gregar et al. 2018). As stated by Noe et al. (2017), three competitive challenges, namely the global challenge, sustainability challenges, and technological challenge, were noted in a viewpoint of business management. Since this study focuses on the global by applying content analysis techniques to the selected literature. They are: (1) the market challenge, the review first categorized the global challenges into eight thematic areas by applying competition, (2) global capital and economic crisis, (3) information communication echnology, (4) content analysis techniques to the selected literature. They are: (1) the market competition, (2) global MNCs, (5) transnational corporations, (6) international terrorism and religious conflicts, (7) capital and economic crisis, (3) information communication echnology, (4) MNCs, (5) transnational international trade war, and (8) international dumping. corporations, (6) international terrorism and religious conflicts, (7) international trade war, and (8) international dumping.

# 5.1. The Challenge of Global Economic Competition

e 1980s with economic globalization (Gunday et al. 2011) and turned more severe after accessing At present, the economic competition is seen in global domains, and it has become severe after the WTO trade regime in 1995. As SMEs build a vital corporation to the economies in developed and the 1980s with economic globalization (Gunday et al. 2011) and turned more severe after accessing developing countries, it is vital to consider the influences of economic competition on SMEs than the WTO trade regime in 1995. As SMEs build a vital corporation to the economies in developed and other industries due to industry-specific features such as low technology base, high concentration in developing countries, it is vital to consider the influences of economic competition on SMEs than the labor-intensive sector, low entry barriers, relatively low fixed costs of production, and mainly other industries due to industry-specific features such as low technology base, high concentration producing price-taker goods (Sener et al. 2014; Prasanna et al. 2019). Today, the WTO is the leading in the labor-intensive sector, low entry barriers, relatively low fixed costs of production, and mainly multilateral organization which governs the global trade and promote the free trade conditions in the producing price-taker goods (Sener et al. 2014; Prasanna et al. 2019). Today, the WTO is the leading global economy. The main agreement that the WTO reached in 1995 is the Agreement on Textiles and multilateral organization which governs the global trade and promote the free trade conditions in the Clothing (ATC). Under the ATC, it was agreed to eliminate all restrictions, specifically phasing out global economy. The main agreement that the WTO reached in 1995 is the Agreement on Textiles and of the Multi-Fiber Arrangement (MFA), imposed on global trade in textiles and clothing under the Clothing (ATC). Under the ATC, it was agreed to eliminate all restrictions, specifically phasing out four stages of the period beginning 1995 to 2005. It abolished the secured market for main garment of the Multi-Fiber Arrangement (MFA), imposed on global trade in textiles and clothing under the exporting countries and opened for international competition. The impact of phasing out of the MFA four stages of the period beginning 1995 to 2005. It abolished the secured market for main garment on SMEs in the industry was evident from factory closes, reduction in workforce, and outflow of exporting countries and opened for international competition. The impact of phasing out of the MFA on SMEs in the industry was evident from factory closes, reduction in workforce, and outflow of out and post MFA periods. For instance, in Sri Lanka, the total number of garment factories have investment to low labor cost countries from increasing labor cost countries during the MFA phasing out and post MFA periods. For instance, in Sri Lanka, the total number of garment factories have 330,000 to 270,000. SMEs were largely the sub-contracted of large-scale firms. Sri Lankan garment declined from 891 in 1999 to 230 in 2013, and the number of workers in the industry reduced from

330,000 to 270,000. SMEs were largely the sub-contracted of large-scale firms. Sri Lankan garment exporters tackled the problem using different strategies such as moving to the product categories where they have comparative advantages in international trade—concentration of high value (niche) items in the product basket which needs specific labor skills, factory merges, value chain adjustments, and productivity enhancement, specifically through the human capital development and technological upgrade in the industry. As a result, the industry managed to report a positive export growth rate in the post-MFA period.

The global economic competition will influence the domestic SMEs more whose productions are excessively localized and segmented because the trade liberalization allows the well-performing foreign manufacturers and retailers to penetrate the underdeveloped and remote markets, which make difficulties to SMEs to maintain their existing sales in the respective small markets (Singh et al. 2009). The report of the United Nations Economic and Social Commission for Asia and the Pacific (United Nations 2009) revealed that in the SMEs in Asia and Pacific region, the current global economy is characterized by trade liberalization, rapidly changing technology, and growing and ever-changing demand for high quality and differentiated intermediated and final goods and services that must meet increasingly stringent international standards. In such an environment, SMEs find it challenging to be competitive even in their domestic market. The product innovation has become a demanding procedure for SMEs because of the increasing global economic competition (Gunday et al. 2011; Gherghina et al. 2019). From research in Malaysia, Mustafa and Yaakub (2018) prepared a list of major challenges for innovation and technology adaptation, including the inadequate budget, lack of resources, difficulties in expanding the existing capacity and improving the quality of products, lack of research and development, low productivity due to inefficient technologies, and lack of new knowledge utilization to develop new products. As there are many challenges in implementing innovations, Mustafa and Yaakub (2018) emphasized that SMEs should make careful decisions regarding planning and operation. They suggest turning to the government for assistance as a strategy. To emphasize that strategy, they highlight an example from Malaysia. The government of Malaysia had performed a vital role in supporting and designing programs to develop the competitiveness of small firms. The government conducted many programs, including sharing knowledge, fund offering, and expert advisory, to improve the innovations and technology adaptations by the SMEs.

As Jinjarak and Wignaraja (2016) mentioned, overcoming financial barriers, having sufficient capital, efficient management of cash flows, and readily accessing global finance are the prerequisites for ventures to be competitive globally. Access to credit is a challenge for most small firms, especially in developing countries. Stein et al. (2013) revealed an excess demand for loanable funds by approximately 17 million firms or $6 0 \%$ of SMEs. Overcoming the financial barriers makes the firms more competitive. Hence, less financially constrained firms show more intensives into exporting (Jinjarak and Wignaraja 2016), and the flexibility of financing is more important for exporting as well. As the WTO stated in the report published in 2016—Levelling the Trading Field for SMEs—an immediate intervention is essential to resolve the above issues to enhance the SMEs’ product competitiveness in the global market.

In more general terms, the SMEs’ dynamic and positive roles are vital factors for constructing competitive regional economies in the global markets (Doh and Kim 2014). For example, in South Korea, the performance and sustainability achieved by SMEs through their dynamic and positive behavior have shown vital importance because of the overwhelms of most economic markets by large sized conglomerates. In addition, enhancing financial situations, exploring research and development, practicing human capital, and working in a cooperative approach with dynamic institutions, including universities at local and global layers, will improve the SMEs’ possibilities for global contesting (Sener et al. 2014). As Ren et al. (2015) studied, marketing is a significant fact that determines the success of SMEs when they compete in the global market. Hence, ineffective marketing is a critical constraint for SMEs to be competitive, locally, and globally (Asare et al. 2015).

The economic competition influences businesses to be vigilant to their business strategies, particularly on innovations (Gunday et al. 2011; Garcia et al. 2020; Kijkasiwat and Phuensane 2020).

Companies start to recognize the significance of innovation with the enhancing competition of global markets when technology change promptly and also when severe global competition rapidly penetrates the value-addition of existing productions and services (Gunday et al. 2011). As per Sener et al. (2014), relating to innovation basis, high value-added products and services will expand the SMEs’ competitiveness in the global context. According to Ahmedova (2015), redirecting the venture from low value-added industries towards niche markets based upon particular competitive benefits and high value-added productions may strengthen the SMEs to face global competition successfully. In some incidents, removing government sanctions will enhance the competitiveness of SMEs in the global market (Singh et al. 2008). Exposing local SMEs for global competition by decreasing trade tariffs gives the international experience for contesting in the global market (Jeppesen 2005).

# 5.2. The Challenge of Global Capital and Economic Crisis

It is a challenge to find definite reasons for the global economic crisis. As stated in the theoretical background, Keynes explains the economic crisis or economic downturn as a deficiency in aggregate demand in the economy. However, economists argue that the collective impact of many causes triggers the crisis within the credit market in the United States and expands to the rest of the world. These facts can be summed up as an imbalance in world trade, consumption patterns in the United States, massive deregulations of the capital markets, and the central role of the US dollar (Ramskogler 2015).

Time gaps are viewed between the occurrences of the global financial crisis. The financial crisis crucially impacts all aspects of economies and SMEs (Sener et al. 2014), and the year 2010 could be considered the most impacted year (Man and Macris 2014). Since SMEs highly depend on customers, suppliers (Nugent and Yhee 2002), and markets (Butler and Sullivan 2005; Narjoko and Hill 2007; OECD 2008), they may lead to increase difficulties in maintaining their activity in the face of a crisis. In 2009, the influence of the problem on the automotive industry was more dangerous than any other sector except housing and finance (Atalay et al. 2013; Shihadeh et al. 2019). As emphasized by Jinjarak and Wignaraja (2016), the global financial crisis created an instant drought in international liquidity, a vital drop in international trade, and extended unemployment. According to Tambunan (2018), many people will become unemployed if many companies go bankrupt due to the national currency’s weakening because of a crisis. The financial crisis stimulated a series of structural changes and influenced them to feel the tasks of SMEs. The crisis’s impact was revealed by the decreasing rate of SME’s development and the extending number of bankruptcies (Man and Macris 2014). With the global economic crisis, the banks tied up the risk management, thereby enhancing the number of restrictions of overdrafts and the number of rejections of loan applications from SMEs (Jinjarak and Wignaraja 2016).

Nevertheless, both expert and government level general concern is that entrepreneurship is a suitable method to confront the economic crisis challenges (GEM 2014). When compared with large-scale businesses, SMEs have to face more inconveniences made by the financial crisis, but SMEs can strongly face the crisis than large-scale ventures. In searching the literature, McMahon (1998) recognized that crisis management on a daily base is the primary aspect of the SMEs’ life cycle. Hence, it is expected to be more prompt and flexibly respond to the frequent changes in the outside environment than large-scale businesses (Eravia et al. 2015). After the economic crisis, the rate of the corporation of SMEs expanded than the large-scale ventures in terms of output, shipments, and value addition; also, after the financial crisis, the number of SMEs was increased, while the number of large-scale ventures decreased (Sung et al. 2016). Nugroho et al. (2017) emphasized that SMEs can survive in the economic crisis era because they have an active market in the country with less or no reliance on the financial service section.

Ahmedova (2015) recognized the SMEs’ possibility to eradicate the adverse results caused by the financial crisis via five critical points for sustainable development and competitiveness. They are entering the finance, innovation tasks, intellectual property associated activities, internationalization, and implementation of best practices. However, adaptability and flexibility are noted as necessary attributes for SMEs to eradicate problems associated with the financial crisis (Man and Macris 2014). Besides the global financial crisis, SMEs played a vital role in the formulation of the labor market and survival of several families after the excessive political turmoil, including the failure of the Soviet Union (Shutyak and Caillie 2015).

Papaoikonomou et al. (2012) argue that most SMEs must suffer from demand shock in this context. As mentioned in OECD (2009), there has been a drop in demand for goods and services and a tightening in credit terms for SMEs globally. The impact of a crisis such as the 1997/1998 crisis, or more specifically, the impact of national currency depreciation on local SMEs, can occur through both demand and supply sides. The supply-side effects occur through the market for factors of production and other inputs, and the demand-side effects occur through the market for final and intermediate goods (Tambunan 2018). The harmful results of the crisis have provided opportunities for governments to react. In this connection, Keynes’s theoretical views could be applicable to manage the overall impacts of the crisis and thereby put the economies into a recovery path. Jinjarak and Wignaraja (2016) highlighted that the intensification of the global financial crisis’s negative impacts motivates the governments to form supportive policies and bring interventions that can support the ventures’ recovery processes. The governments have practiced various strategies to preserve SMEs from the negative influences of the global financial crisis. As Man and Macris (2014) mentioned, loan guarantees, tax subsidies, and capital for research and development for improving innovations and new starts-up are the possible applicable policies the governments could implement. Formulation of government policies to supply additional origins for funding may also strengthen the SMEs to confront a crisis (Ahmedova 2015). As per Ndeye et al. (2018), targeted tax breaks could stimulate SMEs’ development when the recovery after the crisis is slow. It is reviewed that SMEs prominently cooperate with the enterprise’s economic recovery in the years of massive impacts by the world crisis.

The recent financial crises have motivated both Asian and OECD countries to developing alternative financing models in SME finance beyond the conventional ways of relying on bank lending. In Asia, sour experiences of the Asian financial crisis and the global financial crisis sharply raised Asia’s risk consciousness against global economic uncertainty and further highlighted the bank lending limitations to SMEs (OECD 2014). The impact of the crisis has been revealed by decreasing the rate of SME’s development and extending the number of bankruptcies (Man and Macris 2014). Besides, with the global economic crisis, the banks tied up risk management. Therefore, the number of restrictions of overdrafts and the number of rejections of loan applications from SMEs has increased (Jinjarak and Wignaraja 2016).

# 5.3. The Challenge of Information Communication Technology

The growth of information communication technology (ICT) has been identified as one of the intensification factors for internationalization and globalization of SMEs. According to Hogeforster (2014), when going international—which is very expensive—and asking for large investments in foreign countries, small firms should be much thankful for well-developed telecommunication and IT systems, sound transport system, identical rules and regulations, and the internet. Additionally, as knowledge is an essential resource and in the context that resources and resource transfer is more crucial for the usefulness of resources (Narteh 2008), the internet is also identified as a mechanism that transfers the knowledge to SMEs (Hinson and Sorensen 2006).

The significance of ICT has become more decisive in ventures, and both large and small enterprises consider ICT to have a similar influence on enterprise operations as a utility (Rappa 2004). Especially, SMEs can utilize their resources more effectively and improve the savings by adaptation to the internet and the same information and communication technologies (Sener et al. 2014). With the internet, institutions can create international bonds with new vendors to lower the costs, with new customers to enhance the sales, and receive the privilege of declining communication costs, thereby having an efficient and quick transaction procedure (Kabanda and Kent 2018).

Additionally, the internet is a more useful marketing tool for small firms that compete on price (Baldacchino 2005). Internet marketing is a famous enterprise technique in the present. Nugroho et al. (2017) recognized that even specified small industries such as handicrafts and creative industries exercise computer technology and the internet to market their productions with local and foreign market targets. Thus, soft infrastructure, such as full access to the internet and cheap web hosting services, expands the sales and presentations of small and medium businesses (Ndeye et al. 2018).

Low-quality infrastructure in areas such as telecommunication and the internet has been identified as one of the key obstacles for SMEs’ development (Luna et al. 2018). Hence, the lag of information technology growth critically impacts the development of localized small enterprises and their skills to access the global economy (St-Pierre et al. 2015).

Many researchers emphasized that the e-environment supplies a range of chances to SMEs, which proceed with minimal resources (Sceulovs and Gaile-Sarkane 2014; Sung et al. 2016). Hence, more effective adaptation to ICT is essential, not only to optimize the ventures’ internal procedure but also to gain access to the e-business (Ahmedova 2015).

E-commerce and E-marketing have been upgraded because of the e-environment growth (Sceulovs and Gaile-Sarkane 2014). According to the studies based on the use of e-environment by Latvian SMEs, the utility of e-tools improves the effectiveness, profits, and competition of SMEs (Sceulovs and Gaile-Sarkane 2014). Mobile commerce (m-commerce) is a highly beneficial technique used in SMEs worldwide. It leads to increased productivity, improved customer satisfaction, and reduced operational costs of the firms (Chau and Deng 2018). The obstacles for adaptation of m-commerce experienced by SMEs are the scarcity of information communication technology abilities (Helen and Milner 2002), shortage of financial resources (Burn and Tettah 2001; Poon 2002), high dependency on venture partners (Stockdale and Standing 2004), insufficient awareness of e-commerce privileges and the perspective of the adoption of m-commerce, lack of chances to access investments, and the internal technical expertise (Chau and Deng 2018). The social internet networks play a vital role at present, much more than collecting and communicating (Sceulovs and Gaile-Sarkane 2014). With the substantial use of smart mobile phones, the mobile internet is invested in various objectives, such as entrepreneurship (Sceulovs and Gaile-Sarkane 2014). The institutions confront many challenges, including the threat from attackers, spammers, and criminal corporations when they act in the e-environment. The risk is high in developed countries and even more for SMEs, who experience scarcity of resources and cybersecurity methods within their firms (Sulayman et al. 2012).

Typically, the internet is mainly utilized for exchanges with venture partners, finding suppliers for customers, and publishing the firm (St-Pierre et al. 2015). However, implementing financial innovation through the internet could be viewed in the present sphere. Hence, the crowdfunding has been declared as an additional way of gathering funds with the space of financing coupled with enhancements of social media and integrative online platforms. This was identified as a useful additional mechanism for emerging funds by soliciting and gathering little amount from the public with creative projects (Eniola and Entebang 2015). The purpose of crowdfunding is to collect funds for investment via social networks on the internet (Belleflamme et al. 2014) and is identified as a capital innovative used by firms such as SMEs.

# 5.4. The Challenge of Multi-National Corporations

The MNCs have primarily influenced the increased product competition in the global market due to their monopolistic practices and production and distribution merits under strong economies of Scale (Prasanna et al. 2019). This trend has become a challenge for SMEs due to the increased domination of domestic and global markets by the MNCs in the economic globalization era. This questioned the survivable marketability of the SMEs, largely in developing nations, due to the low level of technology adaptation, low managerial skills, productivity issues, labor-intensive nature of the production system, etc. Thus, strategic approaches are suggested to address this critical challenge facing SMEs.

Connecting with ventures that have the right resources is vital to globalize and face international competition rapidly. Thus, businesses follow an enterprise strategy of linking with resourceful ventures for eradicating the shortcomings of resources. In the SMEs, these connections frequently build up with MNCs (Maarof and Mahmud 2016). For instance, after phasing out of MFA along with ATC, many SMEs in the garment industry in Sri Lanka merged with large-scale firms to survive in the market in the free-market era. This was evident from the sharp decline in the number of garment factories in the country while increasing export values and volumes during the post MFA era (Prasanna 2009). This merging strategy supported SMEs to link with MNCs as they held business relationships with them, mainly as sub-contract ways during the MFA era.

As stated at the outset of this section, SMEs contribute as potential suppliers of outsourced parts or services (Tuluce and Dogan 2014). Thus, SMEs must produce the components in the requested quality and provide to MNCs to face competition or get the accepted prices. Therefore, SMEs act another subordinate role by helping the MNCs (Soon 1994). In Singapore, motivating SMEs to help MNCs was a fundamental government strategy (Maarof and Mahmud 2016). In many incidents, the SMEs perform as material suppliers and component assemblers for MNCs (Maarof and Mahmud 2016). According to Soon (1994), Singapore provides the best example of how they address this challenge. At the early stage of Singapore’s economic development, the SMEs played a role in providing support services. The committee appointed to identify the causes of the economic crisis reported that in the mid-1980s, Singapore has suggested redefining the role of SMEs to establish Singapore-led entrepreneurial culture and provide Singapore SMEs to become MNCs in the future. In this connection, the experience of SMEs in working with MNCs was recognized as an advantage to implement the process because SMEs were able to learn managerial and technological lessons from them.

The precious supply connections might provide incentives to MNCs to give technical assistance for SMEs (Maarof and Mahmud 2016). Also, MNCs influence local firms to enhance their management endeavors or adopt new marketing techniques followed by MNCs’ local or foreign markets (Blomstrom and Kokko 1998; cited by Tuluce and Dogan 2014).

According to the economic theories, foreign direct investments (FDI) make spillover privileges to local ventures in host countries. As the MNCs are the ways of international finance and technology, the establishment of MNCs stimulates the transmission of technology enterprise know-how consequence in production to obtain and face competition among SMEs (Tuluce and Dogan 2014). Two modes of spillover impacts are recognized—productivity spillover occurs when the entry of a multi-national corporation (MNC) leads to the productivity or efficiency benefits in the local firms in the host country. In contrast, market accessibility spillovers occur when the entry of the MNC encourages access to export markets for local businesses. As the entry of MNCs into a host country accelerate the transfer of technical knowledge and business know-how, the result is the productivity gains and competitiveness among the local firms. This spillover effect occurs through the linkages between MNCs and local firms becoming either supplier or customer or through the migration of experienced laborers from MNCs to local firms (Blomstrom and Kokko 1998). Further, access to MNCs expands competitiveness and influences SMEs to imitations and innovations (Aldaba and Aldaba 2010).

However, the local ventures must be prepared to work collaboratively with MNCs but not wholly rely on them, because the access of MNCs will separate the monopoly and encourage competitiveness and efficiency or build a more monopolistic industry frame relying on the strength and response of local organizations (Blomstrom and Kokko 1998; cited by Tuluce and Dogan 2014).

# 5.5. The Challenge of Trans-National Corporations (TNCs)

Concerning globalization, TNCs have created a vital effect on host economies via their local sourcing mechanisms, and they exercise territorially based industrial networks as a sourcing and production trick (Chew and Yeung 2001). Hence, TNCs develop an excellent demand for local portions and component suppliers and subcontracting manufacturing (Wang et al. 2018). According to Chew and Yeung (2001), most local SMEs act as suppliers for international TNCs by providing parts, components, and manufacture-related services. The technical knowledge and know-how are critical to producing a quality product at a low cost. The most highlighted domain of transmission of technological knowledge was built from TNCs to SMEs. Though a TNC has specialized in a specific technology, it might not have incentives to transmit it to SMEs because of two causes. Firstly, it might incur costs, and secondly, local suppliers provide instead of any technological assistance from TNCs (Chew and Yeung 2001). Besides, TNCs might not transmit their technical potentiality if there is no reciprocal transmission technological knowledge of know-how arriving from SMEs (Prasanna et al. 2019). However, local organizations are more considered of local knowledge and soft technology than TNCs, and thus, soft technology indicates the procedure and product technologies (Chew and Yeung 2001).

The highly significant localized wisdom aspect is embedded in local and regional links (Chew and Yeung 2001). The other aspect of local wisdom is local technical specifications, standards, management patterns, and local culture. Therefore, there are witnesses for the reverse transmit of technological knowledge or know-how to formulate SMEs to TNCs.

# 5.6. International Terrorism and Religious Conflicts

Terrorism and religious conflicts are a global economic challenge today, and all types of enterprises suffer from the negative consequences of terrorism and religious conflicts. As SMEs are considered as the most dynamic and vulnerable businesses in the global economy, particularly in the economic competition (Munro 2013), those negative consequences are more severe for the SMEs’ sustainability. According to Gaibulloev and Sandler (2008), developed nations can absorb the impact of terrorism without displaying adverse economic effects, but developing nations lack that ability, worsening the situation. Both transnational terrorism and internal conflicts cause adverse consequences on economic growth, and the most severe impact on Asian countries arrives through internal conflicts. Most developing nations in Asia have experienced political violence than the developed nations, suggesting that development cushions the impact of disputes (Gaibulloev and Sandler 2008).

As revealed by Sandler and Enders (2008) the developed nations could regain the general public’s confidence through enhanced security after a terrorist attack, more resilient, and recover faster from the shocks related to the attacks. They can apply the monetary and fiscal policies to control the adverse economic consequences of massive attacks. The most appropriate example is the actions of the USA after the 9/11 attack. The large diversified economies can substitute economic activities from relatively vulnerable sectors to the relatively safe sectors to cushion the losses in economic activities.

Sri Lanka suffered from 30 years of civil war initiated by the LTTE terrorists in the Northern and Eastern Provinces, which ended in 2009. Within those 30 years, SMEs were one of the extremely affected sectors by the war. Many SMEs were destroyed by the arm conflicts; it was highly risky to establish new businesses, and obtaining loan facilities from the bank was difficult. Many problems related to inputs arose, such as lack of electricity, no skilled workers due to the migration, extremely high costs of raw materials, inferior infrastructure facilities such as roads and communication, and lack of marketing facilities. The feeble connections with southern Sri Lanka further shrunk the market access; the demand for goods was very low due to the displacement of people and the loss of income sources for the general public; in that situation, even fulfilling basic needs was a challenge (Sinnathurai 2013).

Imhonopi and Urim (2016) revealed the massive exit of SMEs and large-scale corporations to commercial areas outside terror hot spots to preserve their businesses. Terrorism leads to the disruption of SMEs within the value chain with deleterious ricocheting impact on industrial development. It is difficult for SMEs to change the business location. Thus, the impact may be severe than that of large-scale firms. Specifically, SMEs start their businesses in a specific geographic area by considering the business locational advantages.

Additionally, skilled laborers massively migrate from terror areas to the peaceful regions for safety. Therefore, in the terror areas, the business owners must bear more cost for hiring and insuring skilled laborers. Kato and Kato (2016) show that conflicts negatively influence the gross value added per labor and capital-labor ratio. Terrorism disturbs the education systems of countries and is unable to create human capital for industries. Without trade, the employment generation becomes low, and the unemployment reduces the demand for goods and services, while insecurity lowers the trading velocity within the national boundaries (Imhonopi and Urim 2016).

The travel and tourism industries are most sensitive to terrorism (Baker 2014). From 2014 to 2015, the GDP contribution by tourism in France fell by 1.7 billion US dollars because of terrorist attacks (IEP 2016). The Easter Sunday attack on 21 April 2019 severely impacted the tourism industry in Sri Lanka, and tourist arrivals dropped by more than 70 percent from a year earlier in May and approximately 60 percent in June. From the analysis based on annual data for the period of 1972–2014, Zakaria et al. (2019) revealed that the terrorism impact on domestic investment is significantly negative, and a $1 \%$ increase in terrorism reduces domestic investment by 0.039 percent and economic growth by 0.002 percent in Pakistan. Further, Gaibulloev and Sandler (2008) revealed that an additional terrorist incident per million persons reduces GDP per capita growth by about $1 . 5 \%$ in Asian countries.

Attacks discourage foreign investments and capital inflow and cause severe drawbacks to the economic activities and international trade of the country. As SMEs account for about $9 0 \%$ of economic activities of states and benefit directly from foreign investment (Gamage et al. 2019), those attacks increase insurance, transaction, transportation, and security risks of SMEs (Asgary et al. 2020).

# 5.7. International Trade War

A full-scale trade war began between the US and China since 2018 when Washington decided to renegotiate the US-China economic relationship and reverse the Chinese dominated trade (ISDP 2020). OECD (2019) projects that the global trade war leads to a reduction in global GDP of about $1 . 9 6 \% ,$ and a reduction of global trade of about $1 7 \%$ compared to the scenario of no trade war. As SMEs account for $9 0 \%$ of production in developing and developed countries (Auzzir et al. 2018), SMEs may necessarily experience both positive and negative spillovers of the trade war.

The US-China trade war caused many American companies to move their supply chains out of China, which can be more costly for American SMEs (CRS 2019). On the other hand, Chinese SMEs have a massive loss in their market. With the start of the trade war, many investors have removed their investments in China and placed in other countries, making significant changes in manufacturing sectors in those countries. When the products imported from China to the US become more expensive due to the higher tariffs, US importers moved to the alternatives from other countries such as Vietnam, which is recognized as a country more uncovered to the spillovers of the US-China trade war; both Chinese and US goods affected by trade war will pour into Vietnam (Ho et al. 2018). They also revealed the short- and long-term effects of the US-China trade war on the Vietnam economy. In the short run, Vietnam may benefit from the US-China trade war by replacing Vietnam’s Chinese export of goods to America and relocating China-based manufacturers to Vietnam. However, in the long term, it is expected that the trade war makes challenges to Vietnams’ export-led and foreign investment-led growth model with the slowdown of the global economy. The slower growth could force the businesses to cut down capital spending as monetary market conditions in the United States and some other developed nations tighten. As Vietnam’s economic growth model heavily relies on foreign investments and exports, it may be susceptible to a global economic slowdown and tighter monetary conditions. Malaysia, Indonesia, and the Philippines are also expected to benefit from smaller-scale trade spillovers from China (ISDP 2020).

The most significant negative consequence of the trade war is the slowdown of the global economy. Steinbock (2018) stated that the trade war could contract the global economic expansion, which may adversely impact SMEs’ internationalization. According to ISDP (2020), the trade war has influenced China’s major trading partners, such as Japan, South Korea, and Taiwan. Exports of Hong Kong have decreased since 2018, and in quarter three, the country experienced a recession for the first time in a decade.

# 5.8. International Dumping

In 1923, Jacob Viner first defined the term dumping as “price discrimination between national markets” (Andersson and Thuresson 2008). Dumping is recognized as one of the unfair trade practices that have become a significant issue in the past two decades (Obalade 2014). According to Shepherd et al. (2013), in 1990, the contribution of Zimbabwe manufacturing SMEs to GDP was $2 8 \%$ , and it has declined to $1 7 \%$ by 2011. This decline was due to the shrinking of the local market because of a few factors; product dumping was a significant one.

Mwika et al. (2018) revealed that developing countries fall victim to export dumping by manufacturers in developed countries, which affect their SMEs. APEC (2010) identified competitors’ adoption of dumping practices as a barrier for SMEs entering the international market. They also identified dumping as an anti-competitive behavior SMEs face because it makes difficulties in matching the competitor’s prices. Ogechukwu et al. (2013) described the Nigerian situation and highlighted that with the increasing demand for imported goods, dubious local and foreign importers are dumping fake products that severely impact small manufactures in Nigeria. Therefore, many nations, especially the developing countries, have acted against dumping (Baghdadi et al. 2016). A WTO agreement on the matters related to dumping allows the governments to act against dumping when it causes material injuries to the domestic industries (Andersson and Thuresson 2008). The governments use high tariff rates to discourage importing goods to protect SMEs from dumping, and in some cases, they completely ban the importation (Eze and Okpala 2015). After an in-depth study on dumping in the footwear industry in the European Union, Andersson and Thuresson (2008) emphasized that in most cases, free trade is the best option to protect small but very influential sectors in Europe.

The Action Plan for the National Policy Framework for SMEs Development 2016 identified the value of the effective implementation of the anti-dumping laws to facilitate SMEs in Sri Lanka.

# 6. The Survival Strategies of SMEs Confronting Global Challenges

The survival strategies recognized in this review indicate the importance of establishing the necessary conditions for stabilizing the SMEs-led business environment in the economy and improving the competitiveness of the SMEs in the era of the WTO-led trade regime. The conditions would enhance the ability to protect their markets from different global challenges, mainly reviewed in this study. Ahmedova (2015) stated that SMEs are more vulnerable to economic changes, and as a result, the challenges these organizations face are relatively higher than the large firms. Ifekwem and Adedamola (2016) suggested that SMEs are considered sustainable if they can overcome the challenges by improving their survival chance in the market, either internally or externally.

The SMEs’ survival strategies in encountering global challenges were mainly centered on the fundamental theories discussed at the study’s outset. In terms of the global economic crisis, demand-specific aggregate level policy intervention is needed to protect more vulnerable industries—SMEs in particular—in the economy. It is argued that in the crisis period, most SMEs have to suffer from demand shock because of their limited financial resources and dependence on banks’ lending, paying high interest rates (Mulhern 1996; Domac et al. 1999; Ozar et al. 2008). In this connection, fiscal and monetary approaches can stimulate the aggregate demand in the economy. For instance, COVID-19 pandemic is one of the most recent, serious challenges faced by the global economy. It is said that the world has entered the worst economic recession, which is worse than the 2008 recession (WEO 2020). The affected countries mostly explain the crisis as a sudden fall of demand, so that those economies make policy intervention to stimulate the demand in most economies.

SMEs can identify its strategic position to face the challenge of global and economic competition, firstly through Porter’s generic strategies, either cost leadership, differentiation, cost focus, or differentiation focus. According to past literature, the most effective strategy for SMEs is cost leadership since the expected objectives of SMEs are increasing profits by reducing costs and setting prices according to the industry average. These firms can raise the market share by applying more low prices and still earn a sufficient profit from each sale of a product or a service due to already pressed costs. However, it is hard for SMEs to achieve enough volume for economies of scale. Moreover,ectors. with rising labor costs and increased automation and digitalization, SMEs cost advantages due toFigure 2 presents a frame for the challenges of SMEs (global and local), the requirements of SMEs labor-intensive organizations are eroding, suggesting an alternative focus on other survival strategies,or development, and the survival strategies and policies the SMEs should focus on to gain as presented in Figure 2.sustainability-oriented ou

![](images/d0ea683ae0d5b5d9e9d7cb5e7850130445c5d14c6771524034a4d74a1d05fcf4.jpg)  
Figure 2. Framework for addressing small and medium enterprises’ (SMEs) global and local Figure 2. Framework for addressing small and medium enterprises’ (SMEs) global and local challenges in the globalization based on the literature.

At the same time, SMEs can execute a SWOT analysis to identify the organization’s internal and external factors to face the challenge of global and economic competition, the challenge of Today’s world steps towards a more globalized economy, and no mode of venture could ignore multi-national corporations, and the challenge of transnational corporations. Moreover, SMEs can globalization and skip the challenges caused by globalization. The influence of globalization on SMEs perform a PESTEL analysis to be aware of the competitors as these organizations have a high potential s a vastly reflected theme in economic reviews since the SMEs play a vital role in the sectors of for providing employment, promoting entrepreneurship, earning foreign exchange to the country, production, job creation, poand dispersing industries.

w critically examined the existing literature regarding the key topic, “SMEs and global To confront the challenge of information and communication technology, SMEs can focus on their hallenge.” In terms of SMEs, the global challenge referred to the firms’ ability to protect their strengths, weaknesses, opportunities, and threats existing in the internal and external environment. domestic markets from internal and external shocks and enter new emerging markets in the world. It allows identifying the capability of the SME to adopt those facilities within the SME and determine t analyzed the effects of global challenges on SMEs, the possible lessons taught by the experiences the availability of information and communication technology in the market place because ICT has become a crucial deciding factor in both large and small firms.

Furthermore, SMEs can make the maximum use of the internal resources within the organization and inter-organizational relationships, since they can lead SMEs to get the access and availability to resources (either tangible or intangible), which will create a positive impact to the performance of the organizations and survive in the competition while facing the market place challenges (Rice et al. 2012; Hessels and Parker 2013), and also by acquiring the right network to get necessary resources for their performance (Zaheer and Zaheer 2001).

Ifekwem and Adedamola (2016) recommended that it is necessary to execute orientation and educational programs for the owners of SMEs to sensitize, orientate, and change their thinking patterns, and develop their management skills and abilities to face the global challenges and face the competition to gain sustainable competitive advantage. Identifying the right product with comparative advantages is also recognized as essential determinants to establish conditions to improve competitiveness through resource reallocation from the low productive sector to productive sectors.

Figure 2 presents a frame for the challenges of SMEs (global and local), the requirements of SMEs for development, and the survival strategies and policies the SMEs should focus on to gain sustainability-oriented outcomes in the future.

# 7. Concluding Remarks and Dimensions for Future Research

Today’s world steps towards a more globalized economy, and no mode of venture could ignore globalization and skip the challenges caused by globalization. The influence of globalization on SMEs is a vastly reflected theme in economic reviews since the SMEs play a vital role in the sectors of production, job creation, poverty reduction, innovation, and economic growth in all countries. This review critically examined the existing literature regarding the key topic, “SMEs and global challenge.” In terms of SMEs, the global challenge referred to the firms’ ability to protect their domestic markets from internal and external shocks and enter new emerging markets in the world. It analyzed the effects of global challenges on SMEs, the possible lessons taught by the experiences of different firms, and significant factors necessary to change and improve. The review recognized eight global challenges facing SMEs in the era of economic globalization, i.e., market competition, global capital and economic crisis, information communication technology, MNCs, transnational corporations, international terrorism and religious conflicts, international trade war, and international dumping.

Market competition is a constant outstanding barrier for SMEs. Globalization encourages competition from local ventures and international corporations. Multi-national corporations (MNCs) and transnational corporations (TNCs) have the potential to eradicate global competitive challenges than SMEs and play a vital role in globalized markets. Defeating the financial barriers, having sufficient capital, managing cash flows, and the willingness to access global capital are identified as the pre-suggestions to confront global competition. The shortage in the exploitation of new technologies, marketing, and managing must be urgently solved, while enhancing human resources training, collaborating with dynamic organizations, and redirecting from low value-added manufacturing towards niche markets depending on high value-added productions, to address the global competitive challenges.

With the present globalized economy, MNC producing all aspects of a specific product itself is not cost-effective. Besides, SMEs are oppressing many problems such as the scarcity of resources, technology, know-how, and the markets. Therefore, globalization makes the foundation interact with those two, and SMEs become the aspect or service providers to the MNCs, thereby having a chance to be much more competitive in quality and pricing. Lastly, they build a global value chain. The MNCs supply technical assistant to SMEs and SMEs could also acknowledge the MNCs’ management and marketing exercises; yet, this cannot be viewed every time. If a TNC has the expert knowledge, they might have no incentives to transform it to SME if that incurred a cost and when they lack the transmission of technology and know-how from the SMEs. The reverse transfer of localized wisdom such as local technical specifications, standards, management patterns, and local culture from SMEs to MNCs could be viewed.

Thus, economic globalization constructs a pathway for MNCs and TNCs to access the markets and generate profits by mitigating the production cost by utilizing their specialized knowledge, which is the vital issue arriving from MNCs. The low-cost nations, including China and India, are the best instances. Hence, SMEs should be prepared to interact with and receive advantages from MNCs and must not entirely rely upon them, because the access of MNCs either fragment the monopoly and encourage competition and efficiency, or make a more monopolistic market framework that relies on the strength and response of SMEs.

Although privileges stimulate and motivate SMEs towards globalization, it exposes them to experience many challenges. Limited resources, shortage of technical skills, insufficient knowledge on relevant sectors of foreign backgrounds, less foreign relationships and networks, least innovative capabilities, and the inconveniences to move global initially are some examples.

Two primary paths are available to mitigate the barriers, as mentioned above. One is obtaining R&D and innovative capabilities, and the other is the rapid adaptation of information communication technology (ICT). As the first option is costly and demands specified knowledge time, ICT is the better way towards addressing global challenges. The chance for more effective utilization of resources, potentiality to make new foreign connections with novel vendors to lower the cost, recognize novel customers via internet marketing and take advantages of low communication cost, and privileges from high efficiency and fast transaction procedure are some advantages of adaptation to ICT and the internet. The soft infrastructure facilities, including complete access to the internet and low-cost web host, must be improved because the lag of ICT development creates a notable drawback on the SMEs’ globalization procedure. In this context, the utility of e-tools and the use of smart mobile phones are famous; the SMEs have stepped towards the new trends of entrepreneurial activities, including e-commerce and m-commerce.

Such techniques increase productivity, improves customer satisfaction, and reduces operational costs of the business. The constraints for adapting more ICT-based enterprises are the scarcity of ICT skills, insufficient finance, excessive dependency on venture partners, and inadequate awareness of the privileges of e-tools, and negative attitudes on e-tools. Within the e-environment, the institutions must confront other challenges from attackers, spammers, and criminal corporations. The intensity of the challenges, as mentioned above, is high in developing nations and SMEs with limited spaces to approach cybersecurity.

Institutions form networks with the vital purpose of resource exchange. SMEs could be compensated for their dysfunctions, decrease the transaction costs and risks, exchange knowledge and potentiality, obtain trustworthiness among ventures, receive the no tradable resources including reputation and visibility, build up new market opportunities, intensify innovations, and adopt the right practices and behaviors by embedding in-network. The competition of SMEs relies on its outside networks and the efficiency of using networks than its size.

The global financial crisis impacts all elements of the economy, such as SMEs. The influence on foreign trade, the effect of structural changes of the economy, the less development of ventures, bankruptcies, and the ignorance of loan applications and overdrafts because of the tied risk management of the banks are the main barriers experienced from the global financial crisis.

Many researchers have proved that SMEs can confront financial crises more than large-scale ventures. That capacity has been improved by the access to finance, innovation activities, intellectual property-related tasks, internationalization, and implementation of better exercises by the SMEs. With that, adaptability and flexibility were viewed as more excessive facts necessary to deal with the global financial crisis. The government can implement policies including loan guarantees, tax subsidies, credit for R&D, credit for startups, and additional sources of funding to prevent against and support to rebuild the SMEs from the crisis.

This study investigates the significance of preparing to work on an interactive perspective with MNCs and TNCs, receiving all advantages from them, and developing SMEs towards the MNC layer with that knowledge. The challenges of inadequate resources, insufficient technical skills, expanding competition, and the shortage of other non-market elements could be resolved via embedding in a robust network and efficient use of outside connections. The globalization procedure can be intensified and formulated more cost-effectively by efficiently adapting ICT and using e-tools.

It is also suggested, for future research, to investigate the COVID-19 pandemic as an additional challenge to SMEs and the possible short term and medium-term actions of SMEs to cope with the difficulties and take advantage of possible opportunities (e.g., digitalization, virtual work, health, and safety sector) due to global crisis, such as COVID-19.

Author Contributions: Conceptualization, J.J. and R.P.; methodology, S.K.N.G. and P.R.; investigation, P.R.; resources, S.K.N.G.; writing—original draft preparation, S.K.N.G., E.E. and G.A.; writing—review and editing, R.P.; supervision, J.J.; project administration, R.P.I.R.P; funding acquisition, G.A. All authors have read and agreed to the published version of the manuscript.

Funding: This research was supported by the Accelerating Higher Education Expansion and Development (AHEAD) Operation of the Ministry of Higher Education, funded by the World Bank.

Conflicts of Interest: The authors declare no conflict of interest. The funders had no role in the design of the study in the collection, analyses, or interpretation of data, in the writing of the manuscript, or in the decision to publish the results.

# References

Ahmedova, Sibel. 2015. Factors for Increasing the Competitiveness of Small and Medium-Sizes Enterprises (SMEs) in Bulgaria. Procedia-Social and Behavioral Sciences 195: 1104–12. [CrossRef]   
Ainuddin, R. Azimah, Pawl W. Beamish, John S. Hulland, and Michael J. Rouse. 2007. Resource attributes and firm performance in international joint ventures. Journal of World Business 42: 47–60. [CrossRef]   
Alauddin, Md, and Mustafa Manir Chowdhury. 2015. Small and Medium Enterprise in Bangladesh-Prospects and Challenges. Global Journal of Management and Business Research: C Finance 15: 1–10.   
Aldaba, Rafaelita M., and Fernando T. Aldaba. 2010. Assessing the Spillover Effects of FDI to the Philippines. Discussion Paper Series No. 2010-27; Makati: Pjilippine Institute for Development Studies, pp. 1–48.   
Alfred, M. Pelham, and David T. Wilson. 1996. A Longitudinal Study of the Impact of Market Structure, Firm Structure, Strategy, and Market Orientation Culture on the Dimension of Small-Firm Performance. Journal of the Academy of Marketing Science 24: 27–43. [CrossRef]   
Andalib, Tarnima Warda, and Mohd Ridzuan Darun. 2018. An HRM model for manufacturing companies of Bangladesh mapping employee rights’ protocols and grievance management system. Indian Journal of Science and Technology 11: 1–14. [CrossRef]   
Andersson, Karolina, and Carin Thuresson. 2008. The Impact of an Anti-Dumping Measure—A Study of an Anti-Dumping Measure. Bachelor’s thesis, Jonkoping International Business School, Jonkoping, Sweden.   
APEC. 2010. Removing Barriers to SME Access to International Markets. Hong Kong: Asia Pacific Economic Cooperation.   
Asare, Roland, Mavis Akuffobea, Wilhelmina Quaye, and Kwasi Atta-Antwi. 2015. Characteristics of Micro, Small and Medium Enterprises in Ghana: Gender and Implications for Economic Growth. African Journal of Science, Technology, Innovation and Development 7: 26–35. [CrossRef]   
Asgary, Ali, Ali Ihsan Ozdemir, and Hale Ozyurek. 2020. Small and Medium Enterprises and Global Risks: Evidence from Manufacturing SMEs in Turkey. International Journal of Disaster Risk Science 11: 59–73. [CrossRef]   
Aspers, Patrik, and Sebastian Kohl. 2015. Economic Theories of Globalization. In The Routledge International Handbook of Globalization Studies, 1st ed. Edited by Bryan S. Turner and Robert J. Holton. London: Routledge, vol. 1, pp. 41–59. [CrossRef]   
Atalay, Murat, Nilgun Anafarta, and Fulya Sarvan. 2013. The Relationship between Innovation and Firm Performance: An Empirical Evidence from the Turkish Automotive Supplier Industry. Procedia Social and Behavioral Science 75: 226–35. [CrossRef]   
Auzzir, Zairol, Richard Haigh, and Dilanthi Amaratunga. 2018. Impacts of Disaster to SMEs in Malaysia. Proedia Engineering 212: 1131–38. [CrossRef]   
Ayyagari, Meghana, Thorsten Beck, and Asli Demirguc-Kunt. 2007. Small and Medium Enterprises across the globe. Small Business Economics 29: 415–34. [CrossRef]   
Baghdadi, Leila, Sonia BenKheder, and Hassan Arouri. 2016. Impact of Non-Tariff Measures on SMEs in Tunisia. Tunisia: International Trade Center.   
Baker, David Mc. A. 2014. The Effects of Terrorism on the Travel and Tourism Industry. International Journal of Religious Tourism and Pilgrimage 2: 58–67. [CrossRef]   
Baldacchino, Godfrey. 2005. Successful Small-Scale Manufacturing from Small Islands: Comparing Firms Benefiting from Locally Available Raw Material Input. Journal of Small Business and Entrepreneurship 18: 21–37. [CrossRef]   
Barney, Jay. 1991. Firm Resources and Sustained Competitive Advantage. Journal of Management 17: 99–120. [CrossRef]   
Belleflamme, Paul, Thomas Lambert, and Armin Schwienbacher. 2014. Crowdfunding: Tapping the right crowd. Journal of Business Venturing 29: 585–609. [CrossRef]   
Bernroider, Edward W. N. 2002. Factors in SWOT Analysis Applied to Micro, Small-to-Medium, and Large Software Enterprises. European Management Journal 20: 562–73. [CrossRef]   
Bilal, Zaroug Osman, and Nawal Said Al Mqbali. 2015. Challenges and Constraints Faced by Small and Medium Enterprises (SMEs) in AL Batinah Governorate of Oman. World Journal of Entrepreneurship, Management, and Sustainable Development 11: 120–30. [CrossRef]   
Blomstrom, Magnus, and Ari Kokko. 1998. Multinational corporations and spillovers. Journal of Economic Surveys 12: 1–31. [CrossRef]   
Burn, Janice, and Emmanuel Tettah. 2001. Global strategies for SME business: Applying the SMALL framework. Logistics Information Management 14: 171–80. [CrossRef]   
Butler, J., and J. Sullivan. 2005. Crisis Response Tactics: US SMEs’ Responses to the Asian Financial Crisis. Journal of Business and Entrepreneurship 17: 56.   
Chau, Ngoc Tuan, and Hepu Deng. 2018. Critical Determinants for Mobile Commerce Adoption in Vietnamese SMEs: A Conceptual Framework. Procedia Computer Science 138: 433–40. [CrossRef]   
Chew, Yoke-Tong, and Henry Wai-Chung Yeung. 2001. The SME Advantage: Adding Local Touch to Foreign Transnational Corporations in Singapore. Regional Studies 35: 431–48. [CrossRef]   
Chowdhury, Mohammed S., Rabiul Islam, and Zahurul Alam. 2013. Constraints to the development of small and medium-sized enterprises in Bangladesh: An Empirical Investigation. Australian Journal of Business and Applied Sciences 7: 690–96.   
CRS. 2019. China’s Economic Rise: History, Trends, Challenges, and Implications for the United States. Washington: Congressional Research Service.   
Dess, Gregory G., and Peter S. Davis. 1984. Porter’s generic strategies as determinants of strategic group membership and organizational performance. Academy of Management Journal 27: 467–88.   
Doh, Soogwan, and Byungkyu Kim. 2014. Government Support for SME Innovations in the Regional Industries: The Case of Government Financial Support Programme in South Korea. Research Policy 43: 1557–69. [CrossRef]   
Domac, Ilker, Giovanni Ferri, and Tae Soo Kang. 1999. The Credit Crunch in East Asia: Evidence from Field Findings on Bank Behavior and Policy Issues. World Bank Working Papers. Washington: The World Bank Group.   
Dominguez, Noemie, and Ulrike Mayrhofer. 2017. Internationalization stages of traditional SMEs: Increasing, decreasing and re-increasing commitment to foreign markets. International Business Review 26: 1051–63. [CrossRef]   
Eniola, Anthony Abiodun, and Harry Entebang. 2015. Small Firm Performance-Financial Innovation and Challenges. Procedia-Social and Behavioral Sciences 195: 334–42. [CrossRef]   
Eravia, Diana, Tri Handayani, and Julina. 2015. The Opportunities and Threats of Small and Medium Enterprises in Pekanbaru: Comparison between SMEs in Food and Restaurant Industries. Procedia-Social and Behavioral Sciences 169: 88–97. [CrossRef]   
Erixon, Fredrik. 2018. The Economic Benefits of Globalization for Business and Consumers. Brussels: European Center for International Political Economy.   
Eze, Titus Chinweuba, and Cyril Sunday Okpala. 2015. Quantitative Analysis of the Impact of Small and Medium Scale Enterprises on the Growth of Nigerian Economy: (1993–2011). International Journal of Development and Emerging Economics 3: 26–38.   
Fiseha, Gebregizabher Gebreyesus, and Akeem Adewale Oyelana. 2015. An Assessment of the Roles of Small and Medium Enterprises (SMEs) in the Local Economic Development (LED) in South Africa. Journal of Economics 6: 280–90. [CrossRef]   
Fonseca, Luis, and Filipe Carvalho. 2019. The Reporting of SDGs by Quality, Environmental, and Occupational Health and Safety-Certified Organizations. Sustainability 11: 5797. [CrossRef]   
Fonseca, Luis, Amilcar Ramos, Alvaro Rosa, Ana Cristina Braga, and Paulo Sampaio. 2016. Stakeholders Satisfaction and Sustainable Success. International Journal of Industrial and Systems Engineering 24: 144–57. [CrossRef]   
Gaibulloev, Khusrav, and Todd Sandler. 2008. The Impact of Terrorism and Conflicts on Growth in Asia, 1970–2004—ADB Institute Discussion Paper No. 113. Tokyo: Asian Development Bank.   
Gamage, Sisira Kumara Naradda, E.M.S. Ekanayake, G.A.K.N.J. Abeyrathne, R.P.I.R. Prasanna, J.M.S.B. Jayasundara, and P.S.K. Rajapakshe. 2019. Global Challenges and Survival Strategies of the SMEs in the Era of Economic Globalization: A Systematic Review. Mihintale: Rajarata University of Sri Lanka.   
Garcia, Guadalupe Manzano, Juan Carlos, and Ayala Calvo. 2020. Entrepreneurial Orientation: It’s Relationship with the Entrepreneur’s Subjective Success in SMEs. Sustainability 12: 4547. [CrossRef]   
GEM. 2014. Spain Report. London: Global Entrepreneurship Monitor.   
Gherghina, Stefan Cristian, Mihai Alexandru Botezatu, Alexandra Hosszu, and Liliana Nicoleta Simionescu. 2019. Small and Medium-Sized Enterprises (SMEs): The Engine of Economic Growth through Investment and Innovation. Sustainability 12: 347. [CrossRef]   
Gregar, Ales, Ladislav Kudlacek, Sisira Kumara Naradda Gamage, and Hewa Ravindra Kuruppuge. 2018. Employment Choice of Non-family Professionals in Family Firms. International Scientific Day 2018: 1168–77. [CrossRef]   
Gunday, Gurhan, Gunduz Ulusoy, kemal Kilic, and Lutfihak Alpkan. 2011. Effects of Innovation Types on Firm Performance. International Journal of Production Economics 133: 662–76. [CrossRef]   
Hai, Hui-Lin. 2011. Assessing the SMEs Competitive Strategies on the Impact of Environmental Factors: A Quantitative SWOT Analysis Application. In Environmental Management in Practice. Rijeka: IntechOpen. [CrossRef]   
Helen, Barry, and Brigid Milner. 2002. SMEs and electronic commerce: A departure from the traditional prioritization of training? Journal of European Industrial Training 26: 316–26. [CrossRef]   
Hessels, Jolanda, and Simon C. Parker. 2013. Constraints, internationalization and growth: A cross-country analysis of European SMEs. Journal of World Business 48: 137–48. [CrossRef]   
Hinson, Robert, and Olav Jull Sorensen. 2006. E-business and small Ghanaian exporters: Preliminary micro firm explorations in the light of the digital divide. Online Information Review 30: 116–38. [CrossRef]   
Ho, Tuan, Trang Thi Ngoc Nguyen, and Tho Ngoc Tran. 2018. How will Vietnam Cope with the Impact of the US-China Trade War? Ho Chi Minh City: Yusof Ishak Institute.   
Hogeforster, Max. 2014. Future Challenges for Innovations in SME in the Baltic Sea Region. Procedia-Social and Behavioral Sciences 110: 241–50. [CrossRef]   
Hoque, Abu Shams Mohammad Mahmadul. 2018. The effect of entrepreneurial orientation on Bangladeshi SME performance: Role of organizational culture. International Journal of Data and Network Science 2: 1–14. [CrossRef]   
Hoque, Abu Shams Mohammad Mohamudul, and Zainudin Bin Awang. 2016. The Sway of Entrepreneurial Marketing on Firm Performance: Case of Small and Medium Enterprises (SMEs) in Bangladesh. Paper presented at the Terengganu International Business and Economics Conference (TiBEC-V), Universiti Teknologi Mara (UiTM), Terengganu, Malaysia, September 22–23.   
Hoque, Abu Shams Mohammad Mahmudul, Uzairu Muhammad Gwadabe, and Atiqur Rahman. 2017. Corporate Entrepreneurship Upshot on Innovation Performance: The Mediation of Employee Engagement. Journal of Humanities, Language, Culture and Business 1: 54–67.   
Hoque, Abu Shams Mohammad Mohamudul, Zainudin Bin Awang, Habsah Muda, and Fauzilah Salleh. 2018. Ramification of crowd funding on Bangladeshi Entrepreneur’s Self-Efficiency. Accounting 4: 129–38. [CrossRef]   
Houben, G., K. Lenie, and K. Vanhoof. 1999. A knowledge based SWOT-analysis system as an instrument for strategic planning in small- and medium-sized enterprises. European Management Journal 20: 562–73. [CrossRef]   
Ibrahim, Najafi Auwalu, and Abdulsalam Masud. 2016. Moderating role of entrepreneurial orientation on the relationship between entrepreneurial skills, environmental factors and entrepreneurial intention: A PLS approach. Management Science Letters 6: 225–36. [CrossRef]   
IEP. 2016. Global Terrorism Index 2016—Measuring and Understanding the Impact of Terrorism. New York: Institute for Economics and Peace.   
Ifekwem, Nkiruka, and Ogundeinde Adedamola. 2016. Survival Strategies and Sustainability of Small and Medium Enterprises in the Oshodi-Isolo Local Government Area of Lagos State. Acta Universitatis Sapientiae, Economics and Business 4: 103–18. [CrossRef]   
Imhonopi, David, and Ugochukwu Moses Urim. 2016. The Spectre of Terrorism and Nigeria’s Industrial Development: A Multi-Stakeholder Imperative. African Journal of Criminology and Justice Studies 9: 20–41.   
ISDP. 2020. Snapshot of the U.S.-China Trade War. Washington: Institute for Security and Development Policy.   
Jeppesen, Soeren. 2005. Enhancing Competitiveness and Securing Equitable Development: Can Small, Micro and Medium-Sized Enterprises (SMEs) Do the Trick? Development in Practice 15: 463–74. [CrossRef]   
Jinjarak, Yothin, and Ganeshan Wignaraja. 2016. An Empirical Assessment of the Export-Financial Constraint Relationship: How Different are Small and Medium Enterprises? World Development 79: 152–63. [CrossRef]   
Julita, Julita, and Hasrudy Tanjung. 2019. Development of Porter Generic Strategy Model for Small and Medium Enterprises (SME’s) in Dealing with Asean Economics Community (AEC). International Journal of Recent Scientific Researches 8: 20262–69. [CrossRef]   
Kabanda, Salah Maureen Tanner, and Cameron Kent. 2018. Exploring SME Cyber security Practices in Developing Countries. Journal of Organizational Computing and Electronic Commerce 28: 269–82. [CrossRef]   
Karaev Schmidt, Tobias, and Wolfgang Sofka. 2009. Liability of foreignness as a barrier to knowledge spillovers: Lost in translation? Journal of International Management 15: 460–74. [CrossRef]   
Kato, Atsushi, and Takahiro Kato. 2016. Violent Conflicts and Economic Performance of the Manufacturing Sector in India. Kobe: Research Institute for Economics and Business Administrations.   
Keynes, John Maynard. 1933. The Means of Prosperity. London: Macmillan.   
Khan, Jahaggir H., Abdul Kader Nazmul, Md Farooque Hossain, and Munsura Rahmatullah. 2012. Perception of SME growth constraints in Bangladesh: An empirical examination from institutional perspective. European Journal of Business and Management 4: 256–72.   
Kijkasiwat, Ploypailin, and Pongsutti Phuensane. 2020. Innovations and Fir Performance: The Moderating and Mediating Roles of Firm Size and Small and Medium Enterprise Finance. Journal of Risk and Financial Management 13: 97. [CrossRef]   
Luna, Maribel Dano, Tristan Canare, and Jamil Paolo Francisco. 2018. Drivers of Philippine SME competitiveness: Results of the 2018 SME survey. SSRN Electronic Journal. [CrossRef]   
Maarof, Mohd Ghazali, and Fatimah Mahmud. 2016. A Review of Contributing Factors and Challenges in Implementing Kaizen in Small and Medium Enterprises. Procedia Economics and Finance 35: 522–31. [CrossRef]   
Man, Mariana, and Maria Macris. 2014. Analysis of the SMEs Development in Romania in the Current Europian Context Affected by the Global Economic Crisis. Procedia Economics and Finance 15: 663–70. [CrossRef]   
Martin, Will. 2001. Trade Policies, Developing Countries, and Globalization. Washington: Development Research Group, World Bank.   
McMahon, Richard G. P. 1998. Stage Models of SME Growth Reconsidered. Small Enterprise Research 6: 20–35. [CrossRef]   
Miller, Dannu, Lioyd Steier, and Isabelle Le Breton-Miller. 2003. Lost in time: Intergenerational succession, change, and failure in family businesses. Journal of Business Venturing 16: 33–39. [CrossRef]   
Mulhern, Alan. 1996. Vanezuelan Small Businesses and the Economic Crisis: Reflection from Europe. International Journal of Entrepreneurial Behavior and Research 2: 69–81. [CrossRef]   
Mumbua, Mutisya Swabra. 2013. Competitive Strategies Applied by Small and Medium-Sized Firms in Mombasa County, Kenya. Master’s thesis, School of Business, Univerity of Nairobi, Nirobi, Kenya.   
Mundim, Ana, Alessandro Rossi, and Andrea Stochetti. 2000. SMEs in Global Market: Challenges, Opportunities and Threats. Brazilian Electronic Journal of Economics 3: 418–25.   
Munro, D. 2013. A Guide to Financing SMEs. New York: Palgrave Macmillan.   
Mustafa, Hamidatun Khusna, and Sabariah Yaakub. 2018. Innovation and Technology Adoption Challenges: Impact on SMEs’ Company Performance. International Journal of Accounting, Finance and Business 3: 57–65.   
Mwika, Dickson, Alick Banda, Christopher Chembe, and Douglas Kunda. 2018. The Impact of Globalization on SMEs in Emerging Economies: A case Study of Zambia. International Journal of Business and Social Science 9: 59–68. [CrossRef]   
Narjoko, Dionisius, and Hai Hill. 2007. Winners and Losers during a Deep Economic Crisis: Firm-level Evidence from Indonesian Manufacturing. Asian Economic Journal 21: 343–68. [CrossRef]   
Narteh, Bedman. 2008. Knowledge transfer in developed-developing country inter-firm collaborations: A conceptual framework. Journal of Knowledge Management 12: 78–91. [CrossRef]   
Ndeye, Lutfi Abdul Razak, Ruslan Nagayev, and Adam Ng. 2018. Demystifying Small and Medium Enterprises’ (SMEs) Performance in Emerging and Developing Economies. Borsa Istanbul Review 18: 269–81. [CrossRef]   
Noe, Raymond A., John R. Hollenbeck, Barry Gerhart, and Patrick M. Wright. 2017. Human Resource Management: Gaining a Competitive Advantage, 9th ed. New York: McGraw-Hill.   
Nugent, Jeffrey B., and Seung-Jae Yhee. 2002. Small and Medium Enterprises in Korea: Achievements. Constraints and Policy Issues. Small Business Economics 18: 85–119. [CrossRef]   
Nugroho, Mahendra Adhi, Arief Zuliyanto Susilo, M. Andryzal Fajar, and Diana Rahmawati. 2017. Exploratory Study of SMEs Technology Adoption Readiness Factors. Procedia Computer Science 124: 329–36. [CrossRef]   
Obalade, Timothy A. Falade. 2014. Analysis of Dumping as a Major Cause of Import and Export Crises. International Journal of Humanities and Social Science 4: 233–39.   
OECD. 2008. Annual Report 2008. Paris: Organization for Economic Co-Operation and Development.   
OECD. 2009. Top Barriers and Drivers to SME Internationalization, Report by the OECD Working Party on SME and Entrepreneurship. Paris: Organization for Economic Cooperation and Development.   
OECD. 2014. Annual Report 2014. Paris: Organization for Economic Co-Operation and Development.   
OECD. 2019. Report on G20 Trade and Investment Measures. Paris: OECD, WTO and UNCTAD.   
Ogechukwu, Ayozie Daniel, Jacob. S. Oboreh, F. Umukoro, and Ayozie Victoria Uche. 2013. Small and Medium Scale Enterprises (SMEs) in Nigeria the Marketing Interface. Global Journal of Management and Business Research Marketing 13: 1–13.   
Ong, Jeen Wei, Hisamuddin Ismail, and Peik Foong Yeap. 2010a. Malaysian small and medium enterprises: The fundamental problems and recommendations for improvement. Journal of Asia Entrepreneurship and Sustainability 6: 95–102.   
Ong, Jeen Wei, Hishamuddin Bin Ismail, and Gerald Guan Gan Goh. 2010b. The Competitive Advantage of Small and Medium Enterprises (SMEs): The Role of Entrepreneurship and Luck. Journal of Small Business and Entrepreneurship 23: 373–91. [CrossRef]   
Ozar, Semsa, Gokhan Ozertan, and Zeynep Burcu Irfanoglu. 2008. Micro and Small Enterprise Growth in Turkey: Under the Shadow of Financial Crisis. The Developing Economies 46: 331–62. [CrossRef]   
Papaoikonomou, Eleni, Pere Segerra, and Xiaon Li. 2012. Entrepreneurship in the Context of Crisis: Identifying Barriers and Proposing Strategies. International Advances in Economic Research 18: 111–19. [CrossRef]   
Pelham, Alfred M. 2000. Market orientation and other potential influences on performance in small and medium-sized manufacturing firms. Journal of Small Business Management 38: 48–67.   
Poon, Simpson. 2002. Have the SME benefit from e-commerce. Australian Journal of Information Systems 10: 66–72. [CrossRef]   
Porter, Michael E. 1985. Competitive Advantage. New York: The Free Press, pp. 1–32.   
Prasanna, RPIR. 2009. Impact of $G S P +$ Scheme on Sri Lankan Apparel Industry. Saga: Saga University.   
Prasanna, RPIR, JMSB Jayasundara, Sisira Kumara Naradda Gamage, EMS Ekanayake, PSK Rajapakshe, and GAKNJ Abeyrathne. 2019. Sustainability of SMEs in the Competition: A Systemic Review on Technological Challenges and SME Performance. Journal of Open Innovation: Technology, Market and Complexity 5: 100. [CrossRef]   
Qureshi, Muhammad Imran, Khalid Zaman, and Mansoor Nazir Bhatti. 2011. The impact of culture and gender on leadership behavior: Higher education and management. Management Science Letters 1: 531–40. [CrossRef]   
Rakesh, C. 2014. Pest analysis for micro small medium enterprises sustainability. Journal of Management and Commerce 1: 18–22.   
Ramskogler, Paul. 2015. Tracing the Origins of the Financial Crisis. OECD Journal 2: 47–64. [CrossRef]   
Rappa, Michael A. 2004. The utility business model and the future of computing services. IBM System Journal 43: 32–42. [CrossRef]   
Ren, Shengce, Andreas B. Eisingerich, and Huei-Ting Isai. 2015. How Do Marketing Research and Development Capabilities, and Degree of Internationalization Synergistically Affect the Innovation Performance of Small and Medium-Sized Enterprises (SMEs)? A Panel Data Study of Chinese SMEs. International Business Review 24: 642–51. [CrossRef]   
Rice, John Lewis, T-Sb Liao, NC Martin, and Peter Galvin. 2012. The role of strategic alliances in complementing firm capabilities. Journal of Management and Organization 18: 858–69. [CrossRef]   
Roth, Bernard N, and Stewart A Washburn. 1999. Developing strategy. Journal of Management Consulting 10: 50–54.   
Sandler, Todd, and Walter Enders. 2008. Economic Consequences of Terrorism in Developed and Developing Countries: An Overview. In Terrorism, Economic Development and Political Openness. Edited by Phillip Keefer and Normal Loayza. Cambridge: Cambridge University Press, pp. 17–47.   
Sceulovs, Deniss, and Elina Gaile-Sarkane. 2014. Impact of e-Environment on SMEs Business Development. 2014. Proceedia Social and Behavioral Science 156: 409–13. [CrossRef]   
Sener, Sefer, Mesut Savrul, and Orhan Aydın. 2014. Structure of Small and Medium-Sized Enterprises in Turkey and Global Competitiveness Strategies. Procedia-Social and Behavioral Sciences 150: 212–21. [CrossRef]   
Shepherd, Mupemhi, Richard Duve, and Ronicah Mupemhi. 2013. Factors Affecting the Internationalization of Manufacturing SMEs in Zimbabwe. Gweru: Investment Climate and Business Environment Research Fund. between SME sustainability and banks’ risk. Economic Research-Ekonomska Istraživanja 32: 2743–60. [CrossRef]   
Shutyak, Yulia, and Didier Van Caillie. 2015. The Role of Government in Path-Dependent Development of SME Sector in Ukraine. Journal of East-West Business 21: 67–90. [CrossRef]   
Singh, Rajesh K., Suresh K. Garg, and S. G. Deshmukh. 2008. Strategy Development by SMEs for Competitiveness: A Review. Benchmarking: An International Journal 15: 525–47. [CrossRef]   
Singh, Rajesh K., Suresh K. Garg, and S. G. Deshmukh. 2009. The Competitiveness of SMEs in Globalized Economy, Observations from China and India. Management Research Review 33: 54–65. [CrossRef]   
Sinnathurai, Vijayakumar. 2013. Growth and Issues of Small and Medium Enterprises in Post Conflict Jaffna Sri Lanka. Economia Seria Management 16: 38–53.   
Slater, Stanley F., and John C. Narver. 1990. The Effect of a Market Orientation on Business Profitability. Journal of Marketing 54: 20–35. [CrossRef]   
Soon, Tan Thiam. 1994. A Pragmatic Approach to SME Development in Singapore. Journal of Small Business and Entrepreneurship 11: 38–45. [CrossRef]   
Stein, Peter, Oya Pinar Ardic, and Martin Hommes. 2013. Closing the Credit Gap for Formal and Informal Micro, Small, and Medium Enterprises. Washington: International Finance Corporation, World Bank.   
Steinbock, Dan. 2018. US-China Trade War and Its Global Impacts. China Quarterly of International Strategic Studies 4: 515–42. [CrossRef]   
Stockdale, Rosemary, and Craig Standing. 2004. Benefits and barriers of electronic marketplace participation: An SME perspective. Journal of Enterprise Information Management 17: 301–11. [CrossRef]   
St-Pierre, Josee, Luc Foleu, Georges Abdulnour, Serge Nomo, and Maurice Fouda. 2015. SME Development Challenges in Cameroon: An Entrepreneurial Ecosystem Perspective. Transnational Corporations Review 7: 441–62. [CrossRef]   
Stuart, Elizabeth. 2011. Making Growth Inclusive: Some Lessons from Countries and the Literature. Oxfam Research Report. Nairobi: Oxfam, pp. 1–43.   
Sulayman, Muhammad, Cathy Urquhart, Emilia Mendes, and Stefan Seidel. 2012. Software process improvement success factors for small and medium web companies: A qualitative study. Information and Software Technology 54: 479–500. [CrossRef]   
Sung, Chang-Young, Ki-Chan Kim, and Sungyong In. 2016. Small and Medium-Sized Enterprises Policy in Korea from the 1960s to the 2000s and Beyond. Small Enterprise Research 23: 262–75. [CrossRef]   
Tambunan, Tulus T. H. 2018. The Impact of Economic Crisis on Micro, Small and Medium Enterprises and Their Crisis Mitigation Measures in Southeast Asia With Reference to Indonesia. Asia and Pacific Policy Studies 6: 19–39. [CrossRef]   
Todaro, Michae P., and Stephen C. Smith. 2015. Economic Development. Washington: Pearson.   
Tuluce, Nadide Sevil, and Ibrahim Dogan. 2014. The Impact of Foreign Direct Investments on SMEs’ Development. Procedia Social and Behavioral Sciences 150: 107–15. [CrossRef]   
United Nations. 2009. Globalization of Production and the Competitiveness of Small and Medium-sized Enterprises in Asia and Pacific: Trends and Prospects. New York: Economic and Social Commission for Asia and the Pacific.   
Wang, Yihan, Ari Van Assche, and Ekaterina Turkina. 2018. Antecedents of SME Embeddedness in Inter-Organizational Networks: Evidence from China’s Aerospace Industry. Journal of Small Business and Entrepreneurship 30: 53–75. [CrossRef]   
WEO. 2020. World Economic Outlook. Washington, DC: International Monetary Fund.   
Wiid, Johannes A., Michael C. Cant, and Lizna Holtzhausen. 2015. SWOT analysis in the small business sector of South Africa: Friend or foe? Corporate Ownership and Control 13: 446–53. [CrossRef]   
WTO. 2016. World Trade Report—Levelling the Trading Field for SMEs. Washington: World Trade Organization.   
Xie, Henry, and Taewon Suh. 2014. Perceived resource deficiency and internationalization of small- and medium-sized firms. Journal of International Entrepreneurship 12: 207–29. [CrossRef]   
Yuksel, ˙Ihsan. 2012. Developing a Multi-Criteria Decision Making Model for PESTEL Analysis. International Journal of Business and Management 7: 52–65. [CrossRef]   
Zaheer, Srilata, and Akbar Zaheer. 2001. Market micro structure in a global B2B network. Strategic Management Journal 22: 859–73. [CrossRef]   
Zakaria, Muhammad, Wen Jun, and Haseeb Ahmed. 2019. Effect of Terrorism on Economic Growth in Pakistan: An Empirical Analysis. Economic Research 32: 1794–812. [CrossRef]   
Zeng, S. X., X. M. Xie, and C.M. Tam. 2010. Relationship between cooperation networks and innovation performance of SMEs. Technovation 30: 181–94. [CrossRef]   
Zhang, Yanlong, and Xiu’s Zhang. 2012. The Effect of Entrepreneurial Orientation on Business Performance: A Role of Network Capabilities in China. Journal of Chinese Entrepreneurship 4: 132–42. [CrossRef]

$©$ 2020 by the authors. Licensee MDPI, Basel, Switzerland. This article is an open access article distributed under the terms and conditions of the Creative Commons Attribution (CC BY) license (http://creativecommons.org/licenses/by/4.0/).